﻿var systemmodules = {
    context: $(".v-systemModules"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-systemModulesTable", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getAction("GetSystemModules", "MultiMode", "Settings"),
            columns: [
                { "Title": resources.Id, "Name": "Id", "Data": "Id", "Key": true, "Type": "numeric" },
                { "Title": resources.Name, "Name": "Name", "Data": "Name", "Class": "itemName", "HideInSelector": true },
                { "Title": resources.TelephonyServer, "Name": "TelephonyServer", "Data": "TelephonyServer", "Type": "multiple", "EnumType": "TelephonyServerOptions" },
                { "Title": resources.Status, "Name": "Status", "Data": "StatusEnum", "Type": "enum", "EnumType": "SurveyStatus" },
                { "Title": resources.Type, "Name": "ProntoModuleType", "Data": "TypeLabel", "Type": "enum", "EnumType": "ProntoModuleType" }
            ],
            stateKey: "SystemModules",
            allowRowSelection: function (data) { return (data.Status == 1 || data.Status == 4) && voxco.security.has('DELETE', data.Permissions); },
            toolBarItems: [
                {
                    "Action": "delete", "Label": resources.Delete,
                    "DisplayCondition": function (data) { return (data.Status == 1 || data.Status == 4) && voxco.security.has('DELETE', data.Permissions); }
                }
            ],
            contextMenuItems: [
                {
                    "Action": "advanced", "Label": resources.Advanced,
                    "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions) && (data.ProntoModuleType == 4 || data.ProntoModuleType == 7); }
                },
                { "Divider": true },
                {
                    "Action": "delete", "Label": resources.Delete,
                    "DisplayCondition": function (data) { return voxco.security.has('DELETE', data.Permissions) && (data.Status == 1 || data.Status == 4); }
                },
                {
                    "Action": "properties", "Label": resources.Edit,
                    "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions); }
                },
                {
                    "Action": "users", "Label": resources.Users,
                    "DisplayCondition": function (data) { return voxco.security.has('ADD_USERS_TO_PROJECT', data.Permissions) && (data.ProntoModuleType == 7 || data.ProntoModuleType == 8); }
                },
                { "Divider": true },
                {
                    "Action": "activate", "Label": resources.Start,
                    "DisplayCondition": function (data) {
                        return voxco.security.has('START_STOP', data.Permissions) && (data.Status == 1 || data.Status == 2);
                    }
                },
                {
                    "Action": "pause", "Label": resources.Pause,
                    "DisplayCondition": function (data) {
                        return voxco.security.has('START_STOP', data.Permissions) && data.Status == 3;
                    }
                },
                {
                    "Action": "stop", "Label": resources.Stop,
                    "DisplayCondition": function (data) {
                        return voxco.security.has('START_STOP', data.Permissions) && (data.Status == 2 || data.Status == 3);
                    }
                }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "activate":
                        systemmodules.startModule(row.Id, row.Name);
                        break;
                    case "pause":
                        systemmodules.pauseModule(row.Id, row.Name);
                        break;
                    case "stop":
                        systemmodules.stopModule(row.Id, row.Name);
                        break;
                    case "delete":
                        systemmodules.deleteModules([row.Id]);
                        break;
                    case "properties":
                        systemmodules.editModules(row.Id, row.Type, row.ProntoModuleType);
                        break;
                    case "users":
                        systemmodules.editUsers(row.Id, row.ProntoModuleType);
                        break;
                    case "advanced":
                        systemmodules.editAdvancedProps(row.Id, row.ProntoModuleType);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    systemmodules.deleteModules(ids);
                }
            },
            quickFilter: {
                "DisplayMode": "buttons",
                "Items": [
                    { "Label": resources.Blend, "AjaxParams": { "type": 7 } },
                    { "Label": resources.Monitoring, "AjaxParams": { "type": 8 } },
                    { "Label": resources.RemoteAgent, "AjaxParams": { "type": 5 } }
                ]
            },
            localizableTexts: { "All": resources.AllSystemModules, "Search": resources.SearchSystemModules }
        });
    },
    bindEvents: function () {
        $(".h-newModuleMenu").on("click", "li", function () {
            var moduleType = $(this).attr("data-module-type");
            modalDialog.showWindow(a4.getAction("EditSystemModule", "MultiMode", "Settings", { moduleType: moduleType, moduleId: 0 }), 650, 850, { afterClose: function () { systemmodules.refreshContent(); } });
        });
    },
    deleteModules: function (moduleIds) {
        modalDialog.showConfirmDelete(confirmDeleteModulesResources, function () {
            a4.callServerMethod(a4.getAction("DeleteSystemModules", "MultiMode", "Settings"), { moduleIds: moduleIds },
                function (result) {
                    systemmodules.refreshContent();
                });
        }, moduleIds.length);
    },
    editModules: function (moduleId, type, prontoModuleType) {
        modalDialog.showWindow(a4.getAction("EditSystemModule", "MultiMode", "Settings", { moduleType: prontoModuleType, moduleId: moduleId }), 650, 850, { afterClose: function () { systemmodules.refreshContent(); } });
    },
    editUsers: function (moduleId, prontoModuleType) {
        modalDialog.showWindow(a4.getAction("EditSystemModule", "MultiMode", "Settings", { moduleType: prontoModuleType, moduleId: moduleId, activeTab: "users" }), 650, 850, { afterClose: function () { systemmodules.refreshContent(); } });
    },
    editAdvancedProps: function (moduleId, prontoModuleType) {
        modalDialog.showWindow(a4.getAction("EditSystemModuleInterviewers", "MultiMode", "Settings", { moduleType: prontoModuleType, moduleId: moduleId }), 650, 700, { afterClose: function () { systemmodules.refreshContent(); } });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    startModule: function (moduleId, name) {
        modalDialog.showConfirmDialog(confirmStartModuleResources, function () {
            a4.callServerMethod(a4.getAction("StartSystemModule", "MultiMode", "Settings"), { moduleId: moduleId }, function (result) {
                systemmodules.refreshContent();
            });
        }, null, null, false, { "modulename": name });
    },
    pauseModule: function (moduleId, name) {

        modalDialog.showConfirmDialog(confirmPauseModuleResources, function () {
            a4.callServerMethod(a4.getAction("PauseSystemModule", "MultiMode", "Settings"), { moduleId: moduleId }, function (result) {
                systemmodules.refreshContent();
            });
        }, null, null, false, { "modulename": name });

       
    },
    stopModule: function (moduleId, name) {
        modalDialog.showConfirmDialog(confirmStopModuleResources, function () {
            a4.callServerMethod(a4.getAction("StopSystemModule", "MultiMode", "Settings"), { moduleId: moduleId }, function (result) {
                systemmodules.refreshContent();
            });
        }, null, null, false, { "modulename": name });
    }
}

$(document).ready(function () {
    if (systemmodules.context.length > 0) {
        systemmodules.initializeDataTable();
        systemmodules.bindEvents();
    }
});